function updateRebootStaticOption() {
    var x, str;
    for (x = 0; x < 24; x++) {
        str = ("0" + x + ":00").slice(-5);
        $("#dailyRebootTimeSelect").append($("<option></option>").val(str).text(str));
    }
    for (x = 1; x <= 24; x++) {
        str = (x + " HR");
        $("#timingRebootTimeSelect").append($("<option></option>").val(str).text(str));
    }
}

function updateRebootPageValue() {
    if (cameraSettings.NtpSynchronized == 0) {
        $("#rebootEnableRadio").prop("disabled", true);
        if (cameraSettings.ModelName == "CV730-HN" || cameraSettings.ModelName == "CV420e") {
            $("#applyButton").prop("disabled", true);
            $("#cancelButton").prop("disabled", true);
            $("#rebootDisableRadio").prop("checked", true);
        }
    }
    if (cameraSettings.RebootType == "daily") {
        $("#rebootEnableRadio").prop("checked", true);
    } else if (cameraSettings.RebootType == "timing") {
        $("#rebootTimingRadio").prop("checked", true);
    } else {
        $("#rebootDisableRadio").prop("checked", true);
    }
    $("#dailyRebootTimeSelect").val(cameraSettings.DailyRebootTime);
    $("#timingRebootTimeSelect").val(cameraSettings.TimingRebootTime);
}

function updateRebootType() {
    var rebootType = $("input[name='scheduleReboot']:checked").val();
    if (rebootType == "daily") {
        document.getElementById("dailyRebootTimeSelect").disabled = false;
        document.getElementById("timingRebootTimeSelect").disabled = true;
    } else if (rebootType == "timing") {
        document.getElementById("dailyRebootTimeSelect").disabled = true;
        document.getElementById("timingRebootTimeSelect").disabled = false;
    } else {
        document.getElementById("dailyRebootTimeSelect").disabled = true;
        document.getElementById("timingRebootTimeSelect").disabled = true;
    }
}

function askRebootAction() {
    addTime = 0;
    urlToSend = "/command/main.cgi?";

    AddParameter("System", "reboot");

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Reboot Command Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Reboot Command saved to " + cameraSettings.CameraName);
            reloadReboot();
            UnblockUIforPage();
        }
    });
}

function saveRebootSettings() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/system.cgi?";

    cgiParam.RebootType = $("input[name='scheduleReboot']:checked").val();
    cgiParam.DailyRebootTime = $("#dailyRebootTimeSelect").val();
    cgiParam.TimingRebootTime = $("#timingRebootTimeSelect").val();
    AddParameter("RebootType", cgiParam.RebootType);
    if (cgiParam.RebootType == "daily") {
        AddParameter("DailyRebootTime", cgiParam.DailyRebootTime);
    } else if (cgiParam.RebootType == "timing") {
        AddParameter("TimingRebootTime", cgiParam.TimingRebootTime);
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Reboot Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Reboot settings saved to " + cameraSettings.CameraName);
            reloadReboot();
            UnblockUIforPage();
        }
    });
}

function reloadReboot() {
    openReboot();
}

function openReboot() {
    $("#DivMainPage").load("./page/reboot.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        updateRebootStaticOption();

        $.ajax({
            url: "/command/inquiry.cgi?inqjs=system",
            type: "GET",
            error: function (xhr) {
                console.log("Get reboot info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                updateRebootPageValue();
                updateRebootType();

                $("#rebootButton").on('click', function () {
                    showConfirmationModal("Message", "Do you want to reboot camera?", askRebootAction, null, true);
                });
                $("#rebootEnableRadio").change(updateRebootType);
                $("#rebootDisableRadio").change(updateRebootType);
                $("#rebootTimingRadio").change(updateRebootType);
                $("#applyButton").on('click', saveRebootSettings);
                $("#cancelButton").on('click', reloadReboot);
            }
        });
    });
}
